import bcrypt from "bcrypt";

export const hashPassword = async (password) => {
  try {
    const saltRounds = 10;
    return await bcrypt.hash(password, saltRounds);
  } catch (err) {
    throw err;
  }
};

export const compPassword = async (password, dbPassword) => {
  try {
    const result = await bcrypt.compare(password, dbPassword);
    return result;
  } catch (err) {
    throw err;
  }
};

export const generateRandomPassword = () => {
  const upperCase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  const lowerCase = 'abcdefghijklmnopqrstuvwxyz';
  const digits = '0123456789';
  const special = '!@#$%^&*()';
  const allChars = upperCase + lowerCase + digits + special;
  let newPassword = '';
  newPassword += upperCase[Math.floor(Math.random() * upperCase.length)];
  newPassword += lowerCase[Math.floor(Math.random() * lowerCase.length)];
  newPassword += digits[Math.floor(Math.random() * digits.length)];
  newPassword += special[Math.floor(Math.random() * special.length)];
  for (let i = 4; i < 10; i++) {
    const randomIndex = Math.floor(Math.random() * allChars.length);
    newPassword += allChars[randomIndex];
  }
  newPassword = newPassword
    .split('')
    .sort(() => 0.5 - Math.random())
    .join('');
  return newPassword;
};