import nodemailer from "nodemailer";
import fs from "fs/promises";
import path from "path";
import { fileURLToPath } from "url";
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);


const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOST,
  port: Number(process.env.SMTP_PORT) || 587,
  secure: false,
  // auth: {
  //   user: process.env.SMTP_USER,
  //   pass: process.env.SMTP_PASSWORD,
  // },
  logger: true,
  debug: true,
  tls: {
    rejectUnauthorized: true,
  },
});

export const sendEmail = async ({ to, subject, templateName, variables = {} }) => {
  try {
    const templatePath = path.join(__dirname, `../../templates/${templateName}.html`);
    let htmlContent = await fs.readFile(templatePath, "utf8");

    for (const key of Object.keys(variables)) {
      const regex = new RegExp(`{{${key}}}`, "g");
      htmlContent = htmlContent.replace(regex, variables[key]);
    }

    const info = await transporter.sendMail({
      from: {
        name: "Primal5",
        address: process.env.SMTP_EMAIL,
      },
      to,
      subject,
      html: htmlContent,
    });

    console.log(`✅ Email sent to ${to}, ID: ${info.messageId}`);
    return info.messageId;

  } catch (error) {
    console.error("❌ Email send failed:", error);
    throw new Error("Email sending failed");
  }
};

export const loadHtmlTemplate = async (templateName) => {
  try {
    const filePath = path.resolve(__dirname, `../../templates/${templateName}.html`);
    return await fs.readFile(filePath, "utf8");
  } catch (error) {
    console.error(`❌ Failed to load HTML file (${templateName}):`, error.message);
    return "<h1>Something went wrong. Please try again later.</h1>";
  }
};