import cron from "node-cron";
import * as userModel from "../../models/userModel.js";
import { sendAndroidPush, sendApplePush } from "../../services/notifications/pushNotificationService.js";


export const subscriptionReminderCron = () => {
    cron.schedule("* * * * *", async () => {
        console.log("🔁 [CRON] Running Subscription Reminder Job...");
        try {
            const users = await userModel.getUsersWithoutSubscription();

            const notificationPayload = {
                title: "Complete Your Subscription",
                message: "Subscribe today to unlock all essentials and features!",
                pushType: "1"
            };

            const androidTokens = [];
            const iosTokens = [];
            const notificationRecords = users.map(user => {
                if (user.device_type === "Android") androidTokens.push(user.device_token);
                if (user.device_type === "Apple") iosTokens.push(user.device_token);
                return {
                    user_id: user.id,
                    title: notificationPayload.title,
                    message: notificationPayload.message,
                    pushType: notificationPayload.pushType
                };
            });

            await Promise.allSettled([
                androidTokens.length && sendAndroidPush(notificationPayload, androidTokens),
                iosTokens.length && sendApplePush(notificationPayload, iosTokens)
            ]);

            await userModel.insertNotifications(notificationRecords);

            console.log(`✅ Subscription reminders sent to ${users.length} users.`);
        } catch (error) {
            console.error("❌ Error in Subscription Reminder Cron:", error);
        }
    });
};