import pool from "../config/database.js";
import { Tables } from "../utils/dbTables.js";


export const getAdminByAccessToken = async (access_token) => {
    try {
        const query = `SELECT * FROM ${Tables.ADMIN} WHERE access_token = ? LIMIT 1`;
        const [rows] = await pool.execute(query, [access_token]);
        return rows.length ? rows[0] : null;
    } catch (error) {
        console.error("Error in getUserByAccessToken:", error);
        throw new Error("Database query failed");
    }
};

export const getAdminByEmail = async (email) => {
    try {
        const query = `SELECT * FROM ${Tables.ADMIN} WHERE email = ? LIMIT 1`;
        const [rows] = await pool.execute(query, [email]);
        return rows[0] || null;
    } catch (error) {
        console.error("❌ Error in getAdminByEmail:", error);
        throw error;
    }
};

export const updateAdminToken = async (id, access_token) => {
    try {
        const query = `UPDATE ${Tables.ADMIN} SET access_token = ?, is_logged_in = 1 WHERE id = ?`;
        const [result] = await pool.execute(query, [access_token, id]);
        return result;
    } catch (error) {
        console.error("❌ Error in updateAdminToken:", error);
        throw error;
    }
};

export const logoutAdmin = async (user_id) => {
    try {
        const query = `
            UPDATE ${Tables.ADMIN}
            SET is_logged_in = 0,
                access_token = NULL
            WHERE id = ?
        `;
        const [result] = await pool.execute(query, [user_id]);
        return result;
    } catch (error) {
        console.error("❌ Error in logoutAdmin:", error);
        throw error;
    }
};

export const checkAdminById = async (user_id) => {
    try {
        const query = `SELECT * FROM ${Tables.ADMIN} WHERE id = ? LIMIT 1`;
        const [rows] = await pool.execute(query, [user_id]);
        return rows[0] || null;
    } catch (err) {
        console.error("Error in checkAdminById:", err);
        throw new Error("Database query failed");
    }
};

export const updatePassword = async (user_id, password) => {
    try {
        const query = `UPDATE ${Tables.ADMIN} SET password = ? WHERE id = ?`;
        const [result] = await pool.execute(query, [password, user_id]);
        return result.affectedRows === 1;
    } catch (err) {
        console.error("Error in updatePassword:", err);
        throw new Error("Database update failed");
    }
};