export const validate = (schema) => (req, res, next) => {
    const { error } = schema.validate(req.body, { abortEarly: false });
    if (error) {
        const errors = {};
        error.details.forEach((detail) => {
            const field = detail.path[0];
            if (!errors[field]) errors[field] = [];
            errors[field].push(detail.message.replace(/["]/g, ""));
        });

        const allMessages = error.details
            .map((detail) => detail.message.replace(/["]/g, ""))
            .join(", ");

        return res.status(400).json({
            code: 400,
            status: "error",
            message: allMessages,
            errors,
        });
    }
    next();
};