import jwt from "jsonwebtoken";
import { getUserByAccessToken } from "../models/userAuthModel.js";


export const generateUserToken = (payload) => {
  if (!payload || Object.keys(payload).length === 0) {
    console.error("Payload is empty");
    return null;
  }
  try {
    return jwt.sign(payload, process.env.USER_JWT_SECRET);
  } catch (error) {
    console.error("Error creating JWT token:", error);
    return null;
  }
};

export const authenticateUser = async (req, res, next) => {
  try {
    const authHeader = req.get("authorization");
    if (!authHeader?.startsWith("Bearer ")) {
      return res.status(401).json({
        code: 401,
        message: "Authentication required. Please provide a valid token.",
      });
    }

    const token = authHeader.slice(7);
    let decoded;
    try {
      decoded = jwt.verify(token, process.env.USER_JWT_SECRET);
    } catch {
      return res.status(401).json({
        code: 401,
        message: "Invalid token. Please log in again.",
      });
    }

    const user = await getUserByAccessToken(token);
    if (!user) {
      return res.status(401).json({
        code: 401,
        message: "Invalid token. Please log in again.",
      });
    }

    if (user.is_blocked_by_admin === 1) {
      return res.status(401).json({
        code: 401,
        message: "Your account is blocked by admin.",
      });
    }

    console.log("user_id is>>>>>>>>>>>>>>>>>>>>>>", user.id);
    console.log("user_id is>>>>>>>>>>>>>>>>>>>>>>", user.user_name);
    req.user_id = decoded.user_id;
    req.user_name = user.user_name;
    req.gender = user.gender;
    req.age = user.age;
    next();
  } catch (err) {
    console.error("Error in authenticateUser middleware:", err);
    res.status(500).json({
      code: 500,
      message: "Internal server error.",
    });
  }
};