import jwt from "jsonwebtoken";
import { getAdminByAccessToken } from "../models/adminAuthModel.js";


export const generateAdminToken = (payload) => {
    if (!payload || Object.keys(payload).length === 0) {
        console.error("Payload is empty");
        return null;
    }
    try {
        return jwt.sign(payload, process.env.ADMIN_JWT_SECRET);
    } catch (error) {
        console.error("Error creating JWT token:", error);
        return null;
    }
};

export const authenticateAdmin = async (req, res, next) => {
    try {
        const token =
            req.cookies?.access_token ||
            (req.get("authorization")?.startsWith("Bearer ")
                ? req.get("authorization").slice(7)
                : null);

        if (!token) {
            console.warn("❌ No token found in request");
            return res.redirect("/");
        }

        let decoded;
        try {
            decoded = jwt.verify(token, process.env.ADMIN_JWT_SECRET);
        } catch (error) {
            console.warn("❌ Invalid or expired token:", error.message);
            return res.redirect("/");
        }

        const admin = await getAdminByAccessToken(token);
        if (!admin) {
            console.warn("❌ No admin found for this token");
            return res.redirect("/");
        }

        console.log("✅ Authenticated Admin ID:", admin.id);
        console.log("✅ Admin Username:", admin.user_name);

        req.user_id = decoded.user_id;
        next();

    } catch (err) {
        console.error("🔥 Error in authenticateAdmin middleware:", err);
        res.redirect("/");
    }
};