import express from "express";
import path from "path";
import cors from "cors";
import { fileURLToPath } from "url";
import { dirname } from "path";
import cookieParser from "cookie-parser";
import registerApiRoutes from "./api/index.js";

const __filename = fileURLToPath(import.meta.url);
const __dirname = dirname(__filename);

const app = express();

app.set("views", path.join(__dirname, "views"));
app.set("view engine", "ejs");
app.locals.adminApiBaseUrl = process.env.ADMIN_API_BASE_URL;

app.use(cors());
app.use(cookieParser());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use("/uploads", express.static(path.join(__dirname, "../storage/uploads")));
app.use(express.static(path.join(__dirname, "../public")));

app.get('/', (req, res) => res.render('admin/login'));
app.get('/terms-of-service', (req, res) => res.render('static/terms-of-service'));
app.get('/privacy-policy', (req, res) => res.render('static/privacy-policy'));
app.get('/disclaimer', (req, res) => res.render('static/disclaimer'));

registerApiRoutes(app);

app.use((err, req, res, next) => {
  console.error(err.stack);
  res.status(err.status || 500).json({
    success: false,
    message: err.message || "Internal Server Error",
  });
});

export default app;