import Joi from "joi";

export const login = Joi.object({
    email: Joi.string()
        .trim()
        .lowercase()
        .email({ tlds: { allow: false } })
        .required()
        .messages({
            "string.empty": "Email is required",
            "string.email": "Please provide a valid email address",
        }),
    password: Joi.string()
        .min(6)
        .max(128)
        .pattern(/^\S+$/, "no spaces")
        .required()
        .messages({
            "string.empty": "Password is required",
            "string.min": "Password must be at least 6 characters long",
            "string.max": "Password must not exceed 128 characters",
            "string.pattern.name": "Password must not contain spaces",
        }),
});