import { Router } from "express";
import * as userController from "../controllers/user/userController.js";
import { authenticateUser } from "../../../middlewares/userAuthMiddleware.js";
import { validate } from "../../../middlewares/validate.js";
import * as userValidation from "../validations/userValidation.js";
import upload from  "../../../services/storage/multerService.js";

const router = Router();
router.use(authenticateUser);


router.get("/profile", userController.getUserProfile);

router.put("/mark-welcome-done", userController.markWelcomeDone);

router.get("/essentialsListing", userController.essentialsListing);

router.post("/add-age-gender", userController.addAgeGender);

router.get("/question", userController.getQuestionWithOptions);

router.get("/options", userController.getOptionsByEssentialsId);

router.post("/saveUserEssential", userController.saveUserEssential);

router.get("/home", userController.home);

router.put("/edit-profile", upload.single("profile_image"), userController.editUserProfile);

router.get("/notifications", userController.getNotifications);

router.delete("/notifications", userController.deleteNotification);

router.get("/essentialsTips", userController.essentialsTips);

router.get("/getUserAvailableMonths", userController.getUserAvailableMonths);

router.get("/getUserProgress", userController.getUserProgress);

router.get("/getSuggestions", userController.getSuggestions);


export default router;