import { Router } from "express";
import * as userAuthController from "../controllers/auth/userAuthController.js";
import { authenticateUser } from "../../../middlewares/userAuthMiddleware.js";
import { validate } from "../../../middlewares/validate.js";
import * as userAuthValidation from "../validations/userAuthValidation.js";
const router = Router();

// ----------------------------- Public routes ----------------------------------

router.post("/signup", validate(userAuthValidation.signup), userAuthController.signUp);

router.post("/login", validate(userAuthValidation.login), userAuthController.login);

router.post("/forgotPassword", validate(userAuthValidation.forgotPassword), userAuthController.forgotPassword);

router.post("/googleLogin", validate(userAuthValidation.googleLogin), userAuthController.googleLogin);

router.post("/appleLogin", validate(userAuthValidation.appleLogin), userAuthController.appleLogin);

router.get("/verify_email/:id", userAuthController.verifyEmail);

// ----------- Account Deletion -------------
router.get("/account/delete/request-otp", (req, res) => res.render("users/deleteAccountOtp"));
router.post("/account/delete/request-otp", userAuthController.sendOtpForAccountDeletion);
router.post("/account/delete/verify-otp", userAuthController.verifyOtpAndDeleteAccount);
// ----------- Account Deletion -------------

// ------------------------------- Protected routes ------------------------------

router.use(authenticateUser);

router.post("/help-support", validate(userAuthValidation.helpAndSupport), userAuthController.helpAndSupport);

router.post("/changePassword", userAuthController.changePassword);

router.post("/logout", userAuthController.logout);

router.get("/deleteAccount", userAuthController.deleteAccount);


export default router;