import { Router } from "express";
import * as subscriptionController from "../controllers/subscription/subscriptionController.js";
import { authenticateUser } from "../../../middlewares/userAuthMiddleware.js";
import { validate } from "../../../middlewares/validate.js";
import * as subscriptionValidation from "../validations/subscriptionValidation.js";

const router = Router();


router.get("/google-auth", subscriptionController.getGoogleAuthUrl);

router.get("/google-callback", subscriptionController.googleCallback);


router.use(authenticateUser);

router.post("/add", subscriptionController.addSubscription);

router.post("/cancel", subscriptionController.cancelSubscription);

router.get("/check", subscriptionController.checkSubscription);


export default router;