import { Router } from "express";
import * as adminController from "../controllers/admin/adminController.js";
import { authenticateAdmin } from "../../../middlewares/adminAuthMiddleware.js";
import { validate } from "../../../middlewares/validate.js";
import * as adminValidation from "../validations/adminValidation.js";
import upload from  "../../../services/storage/multerService.js";
const router = Router();

router.use(authenticateAdmin);

// Rendered Pages
router.get('/dashboard', (req, res) => res.render('admin/dashboard'));
router.get('/mass-push', (req, res) => res.render('admin/massPush'));
router.get('/change-password', (req, res) => res.render('admin/changePassword'));
router.get('/users', (req, res) => res.render('admin/usersListing'));
router.get('/subscribed-users', (req, res) => res.render('admin/subscribedUsersListing'));
router.get('/manage-quotes', (req, res) => res.render('admin/quotesCrud'));


// Action Routes
router.post("/mass-push", adminController.massPush);
router.get("/mass-push/history", adminController.getMassPushHistory);

router.get("/getUsersList", adminController.getUsersList);
router.post("/updateUserStatus", adminController.updateUserStatus);
// router.get("/subscribedUsers", adminController.getSubscribedUsersList);
router.get("/user-details/:id", adminController.userDetails);
router.get("/user-monthly-progress", adminController.getUserMonthlyProgress);



router.post("/quotes", adminController.addQuote);
router.put("/quotes", adminController.updateQuote);
router.delete("/quotes/:quote_id", adminController.deleteQuote);
router.get("/quotes", adminController.getAllQuotes);
router.post("/quotes/bulk-upload", upload.single("file"), adminController.bulkUploadQuotes);


export default router;