import { Router } from "express";
import * as adminAuthController from "../controllers/auth/adminAuthController.js";
import { authenticateAdmin } from "../../../middlewares/adminAuthMiddleware.js";
import { validate } from "../../../middlewares/validate.js";
import * as adminAuthValidation from "../validations/adminAuthValidation.js";

const router = Router();

router.post("/login", validate(adminAuthValidation.login), adminAuthController.login);


router.use(authenticateAdmin);

router.post("/logout", adminAuthController.logout);

router.post("/changePassword", adminAuthController.changePassword);

router.get("/profile", adminAuthController.getAdminProfile);


export default router;