import userAuthRoutes from "../api/v1/routes/userAuthRoutes.js";
import userRoutes from "../api/v1/routes/userRoutes.js";
import subscriptionRoutes from "../api/v1/routes/subscriptionRoutes.js";
import adminAuthRoutes from "../api/v1/routes/adminAuthRoutes.js";
import adminRoutes from "../api/v1/routes/adminRoutes.js";


const registerApiRoutes = (app) => {

  const API_V1 = "/api/v1";

  app.use(`${API_V1}/user/auth`, userAuthRoutes);
  app.use(`${API_V1}/user`, userRoutes);
  app.use(`${API_V1}/subscription`, subscriptionRoutes);

  app.use(`${API_V1}/admin/auth`, adminAuthRoutes);
  app.use(`${API_V1}/admin`, adminRoutes);

};

export default registerApiRoutes;