import http from "http";
import dotenv from "dotenv";
import app from "./src/app.js";
import { testConnection } from "./src/config/database.js";
import logger from "./src/utils/logger.js";
import { checkAndroidSubscriptionsCron } from "./src/scripts/cron/checkAndroidSubscriptionsCron.js";
import { subscriptionReminderCron } from "./src/scripts/cron/subscriptionReminderCron.js";
import { essentialsReminderCron } from "./src/scripts/cron/essentialsReminderCron.js";
dotenv.config();

const PORT = process.env.PORT || 3482;
const server = http.createServer(app);

const startServer = async () => {
  await testConnection();
  server.listen(PORT, () => {
    logger.info(`🚀 Server is running at: ${PORT}`);

    // checkAndroidSubscriptionsCron();
    // subscriptionReminderCron();
    essentialsReminderCron();
    logger.info("🕒 Android subscription cron initialized");
  });
};

startServer().catch((err) => {
  logger.error(`Failed to start server: ${err.message}`);
  process.exit(1);
});