export function renderPagination(containerId, totalPages, currentPage, onPageClick) {
    const pagination = document.getElementById(containerId);
    if (!pagination) return;

    pagination.innerHTML = '';
    if (totalPages <= 1) {
        pagination.style.display = 'none';
        return;
    } else {
        pagination.style.display = 'flex';
    }

    const maxVisibleButtons = 4;
    let startPage = Math.max(1, currentPage - Math.floor(maxVisibleButtons / 2));
    let endPage = Math.min(totalPages, startPage + maxVisibleButtons - 1);
    if (endPage - startPage < maxVisibleButtons - 1) {
        startPage = Math.max(1, endPage - maxVisibleButtons + 1);
    }

    function createPageItem(page, text = page, active = false) {
        const li = document.createElement('li');
        li.innerHTML = `<a href="#" data-page="${page}" class="${active ? 'active-page' : ''}">${text}</a>`;
        li.addEventListener('click', e => {
            e.preventDefault();
            onPageClick(page);
        });
        return li;
    }

    if (currentPage > 1) {
        const prev = document.createElement('li');
        prev.innerHTML = `<a href="#" class="prev-btn" style="background-color:#e9d2a5;color:black">Previous</a>`;
        prev.addEventListener('click', e => { e.preventDefault(); onPageClick(currentPage - 1); });
        pagination.appendChild(prev);
    }

    if (startPage > 1) {
        pagination.appendChild(createPageItem(1));
        if (startPage > 2) {
            const ellipsis = document.createElement('li');
            ellipsis.innerHTML = `<span>...</span>`;
            pagination.appendChild(ellipsis);
        }
    }

    for (let i = startPage; i <= endPage; i++) {
        pagination.appendChild(createPageItem(i, i, i === currentPage));
    }

    if (endPage < totalPages) {
        if (endPage < totalPages - 1) {
            const ellipsis = document.createElement('li');
            ellipsis.innerHTML = `<span>...</span>`;
            pagination.appendChild(ellipsis);
        }
        pagination.appendChild(createPageItem(totalPages));
    }

    if (currentPage < totalPages) {
        const next = document.createElement('li');
        next.innerHTML = `<a href="#" class="next-btn" style="background-color:#e9d2a5;color:black">Next</a>`;
        next.addEventListener('click', e => { e.preventDefault(); onPageClick(currentPage + 1); });
        pagination.appendChild(next);
    }
};